/**
 * @file	halopus_platform.h
 * @brief	OPUS hardware abstraction library (libhalopus) platform specific header
 *
 * @author	Thomas Pinske <tpinske@topcon.com>
 * @copyright	( c ) 2016 Wachendorff Elektronik GmbH & Co. KG, Geisenheim
 * 		All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _HALOPUS_H_
# error "Never include <halopus_platform.h> directly; use <halopus.h> instead."
#endif

#ifndef _HALOPUS_PLATFORM_H_
#define _HALOPUS_PLATFORM_H_

/******************************************************************************
 * SENSORS
 *****************************************************************************/
/**
 * @enum	opus_sensors
 * @brief	available sensors
 */
enum opus_sensors {
	OPUS_SENSOR_VOLT_SUPPLY = 0,		/* measures voltage of power supply */
	OPUS_SENSOR_VOLT_VIDEO,			/* measures voltage of video power supply */
	OPUS_SENSOR_TEMPERATURE,		/* measures temperature (main temp. sensor) */
	OPUS_SENSOR_LIGHT,			/* measures light (main light sensor) */
	OPUS_SENSOR_SNIFFPAD,			/* measures sniffpad voltage */

	/* counter, always last entry */
	OPUS_SENSOR_COUNT
};


/******************************************************************************
 * EEPROM
 *****************************************************************************/
#define OPUS_EEPROM_I2C_ID			"0-0050"


/******************************************************************************
 * POWER REGULATORS
 *****************************************************************************/
#include <linux/regulator/regnetlink.h>
#include <linux/regulator/reg-opusa3.h>

/* wrapper for platform specific event I/F defines */
#define OPUS_REGULATOR_GENL_NAME		"REG_OPUSA3"
#define OPUS_REGULATOR_GENL_C_EVENT		REG_GENL_C_EVENT
#define OPUS_REGULATOR_GENL_A_REGULATOR		REG_GENL_A_REGULATOR
#define OPUS_REGULATOR_GENL_A_EVENT		REG_GENL_A_EVENT
#define OPUS_REGULATOR_GENL_E_POWER_ON		REG_GENL_EVENT_POWER_ON
#define OPUS_REGULATOR_GENL_E_POWER_OFF		REG_GENL_EVENT_POWER_OFF


#endif /* _HALOPUS_PLATFORM_H_ */
