/*----------------------------------------------------------------------------*/
/**
 * @file		analog_class.h
 * @author		Thomas Pinske <tpe@wachendorff.de>
 * @copyright	( c ) Wachendorff Elektronik GmbH & Co. KG 2013
 * @brief		Analog input and sensor device class driver
 *
 * The analog input and sensor device class provides an interface for
 * analog inputs and sensors. It contains automatic creation of SYSFS
 * attributes and an event interface compatible with the WE event I/F.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/

#ifndef ANALOG_CLASS_H_
#define ANALOG_CLASS_H_

/* event interface */
#define ANALOG_SYS_GENL_NAME		"ANALOG"
#define ANALOG_SYS_GENL_VERSION		1

/**
 * @enum		<unnamed>
 * @brief		This enum lists all supported commands of event interface
 */
enum
{
	ANALOG_GENL_C_UNSPEC,
	ANALOG_GENL_C_EVENT,			/* This command signals an event */
  __ANALOG_GENL_C_COUNT,
};
#define ANALOG_GENL_C_MAX			(__ANALOG_GENL_C_COUNT - 1)

/**
 * @enum		<unnamed>
 * @brief		This enum lists all supported attributes of event interface
 */
enum
{
	ANALOG_GENL_A_UNSPEC,
	ANALOG_GENL_A_NAME,				/* This attribute defines the analog input/sensor name (string) */
	ANALOG_GENL_A_EVENT,			/* This attribute defines the event bit mask (u8) */
	ANALOG_GENL_A_VALUE,			/* This attribute defines the analog (scaled) value (s32) */
  __ANALOG_GENL_A_COUNT,
};
#define ANALOG_GENL_A_MAX			(__ANALOG_GENL_A_COUNT - 1)

/* event flag bit masks */
#define ANALOG_EVENT_CHANGE			(1 << 0)		/* value has changed */
#define ANALOG_EVENT_LOW_LIMIT		(1 << 1)		/* value is below low limit */
#define ANALOG_EVENT_HIGH_LIMIT		(1 << 2)		/* value is above high limit */



#endif /* ANALOG_CLASS_H_ */
