/*
 * Copyright (C) 2008
 * Guennadi Liakhovetski, DENX Software Engineering, <lg@denx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ASM_ARCH_MX3FB_H__
#define __ASM_ARCH_MX3FB_H__

#include <linux/fb.h>

/* Proprietary FB_SYNC_ flags */
#define FB_SYNC_OE_ACT_HIGH	0x80000000
#define FB_SYNC_CLK_INVERT	0x40000000
#define FB_SYNC_DATA_INVERT	0x20000000
#define FB_SYNC_CLK_IDLE_EN	0x10000000
#define FB_SYNC_SHARP_MODE	0x08000000
#define FB_SYNC_SWAP_RGB	0x04000000
#define FB_SYNC_CLK_SEL_EN	0x02000000

/**
 * @struct		mx3fb_gbl_alpha
 * @brief		data used to set global alpha
 */
struct mx3fb_gbl_alpha
{
	int enable;				/* enable/disable global alpha */
	__u8 alpha;				/* alpha value to use */
};


/**
 * @struct		mx3fb_color_key
 * @struct		data used to set color key
 */
struct mx3fb_color_key
{
	int enable;
	__u32 color_key;
};


#define MX3FB_SET_GBL_ALPHA     _IOW('F', 0x21, struct mx3fb_gbl_alpha)
#define MX3FB_SET_CLR_KEY       _IOW('F', 0x22, struct mx3fb_color_key)
/*
 *  Range 0x23 - 0x2D is used by Freescale/NXP FB driver.
 * Keep this range free for future development, to stay aligned with that
 */
#define MX3FB_GET_GBL_ALPHA     _IOR('F', 0x31, struct mx3fb_gbl_alpha)
#define MX3FB_GET_CLR_KEY       _IOR('F', 0x32, struct mx3fb_color_key)



#endif
