/*----------------------------------------------------------------------------*/
/**
 * @file		pwm_speaker.h
 * @author		Thomas Pinske <tpe@wachendorff.de>
 * @copyright	( c ) Wachendorff Elektronik GmbH & Co. KG 2008 - 2013
 * @brief		PWM based speaker and beeper driver
 *
 * This driver can be used to access speaker devices which are connected
 * through a PWM. It can also be used with beeper (buzzer) devices.
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/

#ifndef _PWM_SPEAKER_H
#define _PWM_SPEAKER_H

/*============================================================================*/
/* GENERIC NETLINK EVENT INTERFACE                                            */
/*============================================================================*/
#define PWM_SPEAKER_GENL_NAME		"SPEAKER"
#define PWM_SPEAKER_GENL_VERSION	1

/**
 * @enum <unnamed>
 * @brief This enum lists all supported commands of event interface
 */
enum
{
	PWM_SPEAKER_GENL_C_UNSPEC,
	PWM_SPEAKER_GENL_C_EVENT,                     /* This command signals an event */
  __PWM_SPEAKER_GENL_C_COUNT,
};
#define PWM_SPEAKER_GENL_C_MAX	(__PWM_SPEAKER_GENL_C_COUNT - 1)

/**
 * @enum <unnamed>
 * @brief This enum lists all supported attributes of the DIO-event interface
 */
enum
{
	PWM_SPEAKER_GENL_A_UNSPEC,
	PWM_SPEAKER_GENL_A_NUM,			/* This attribute defines the speaker number */
	PWM_SPEAKER_GENL_A_EVENT,		/* This attribute defines the speaker event */
	PWM_SPEAKER_GENL_A_VOLUME,		/* This attribute defines the speaker volume */
	PWM_SPEAKER_GENL_A_FREQ,		/* This attribute defines the speaker PWM frequency */
	PWM_SPEAKER_GENL_A_DUTY,		/* This attribute defines the speaker PWM duty cycle */
  __PWM_SPEAKER_GENL_A_COUNT,
};
#define PWM_SPEAKER_GENL_A_MAX	(__PWM_SPEAKER_GENL_A_COUNT - 1)

/* event signaling */
#define PWM_SPEAKER_EVENT_VOLUME	(1 << 0)		/* event "volume change" bit mask */
#define PWM_SPEAKER_EVENT_FREQ		(1 << 1)		/* event "frequency change" bit mask */
#define PWM_SPEAKER_EVENT_DUTY		(1 << 2)		/* event "duty cycle change" bit mask */



#endif /*_PWM_SPEAKER_H*/

