/**
 * @file reg-weimx6-boardpmic.h
 * @author tsr@wachendorff.de
 * @copyright ( c ) 2012 Wachendorff Elektronik GmbH & CO. KG, All Rights Reserved.
 * @brief declarations for regulators on weimx6 board pmic
 */

#ifndef REG_WEIMX6_BOARDPMIC_H_
#define REG_WEIMX6_BOARDPMIC_H_

#define REG_WEIMX6_BOARDPMIC_GENL_NAME    "REG_WEIMX6_BRD"
#define REG_WEIMX6_BOARDPMIC_GENL_VERSION 1

/**
 * @enum reg_weimx6_boardpmic_dev_id
 * @brief This enum lists all regulator device IDs
 */
enum reg_weimx6_boardpmic_dev_id
{
	REG_WEIMX6_BOARDPMIC_KL15_WAKEUP = 0,
	REG_WEIMX6_BOARDPMIC_CAN1_SHDN,
	REG_WEIMX6_BOARDPMIC_CAN2_SHDN,
	REG_WEIMX6_BOARDPMIC_VIDDEC1_RST,
	REG_WEIMX6_BOARDPMIC_VIDDEC2_RST,
	REG_WEIMX6_BOARDPMIC_12V_VID_PWR,
	REG_WEIMX6_BOARDPMIC_BT_EN,
	REG_WEIMX6_BOARDPMIC_BT_RST,
	REG_WEIMX6_BOARDPMIC_NUM_REGULATORS
};

/**
 * @enum reg_weimx6_boardpmic_commands
 * @brief This enum lists all supported commands of event interface
 */
enum reg_weimx6_boardpmic_commands
{
  REG_WEIMX6_BOARDPMIC_GENL_C_UNSPEC,
  REG_WEIMX6_BOARDPMIC_GENL_C_EVENT, /* This command signals an event */
  __REG_WEIMX6_BOARDPMIC_GENL_C_COUNT,
};
#define REG_WEIMX6_BOARDPMIC_GENL_C_MAX   (__REG_WEIMX6_BOARDPMIC_GENL_C_COUNT - 1)

/**
 * @enum reg_weimx6_boardpmic_attributes
 * @brief This enum lists all supported attributes of the sensor event interface
 */
enum reg_weimx6_boardpmic_attributes
{
	REG_WEIMX6_BOARDPMIC_GENL_A_UNSPEC,
	REG_WEIMX6_BOARDPMIC_GENL_A_REGULATOR, /* This attribute defines the regulator number */
	REG_WEIMX6_BOARDPMIC_GENL_A_EVENT, /* This attribute defines the regulator event */
	__REG_WEIMX6_BOARDPMIC_GENL_A_COUNT,
};
#define REG_WEIMX6_BOARDPMIC_GENL_A_MAX  (__REG_WEIMX6_BOARDPMIC_GENL_A_COUNT - 1)

/* valid regulator states */
#define REG_WEIMX6_BOARDPMIC_STATE_OFF   0
#define REG_WEIMX6_BOARDPMIC_STATE_ON    1


#endif /*REG_WEIMX6_BOARDPMIC_H_*/
