#ifndef REGNETLINK_H_
#define REGNETLINK_H_

/**
 * @enum <unnamed>
 * @brief This enum lists all supported commands of the power regulator netlink interface
 */
enum
{
  REG_GENL_C_UNSPEC,
  REG_GENL_C_EVENT,                     /* This command signals a regulator event */
  __REG_GENL_C_COUNT,
};
#define REG_GENL_C_MAX   (__REG_GENL_C_COUNT - 1)

/**
 * @enum <unnamed>
 * @brief This enum lists all supported attributes of the power regulator netlink interface
 */
enum
{
  REG_GENL_A_UNSPEC,
  REG_GENL_A_REGULATOR,                 /* This attribute defines the regulator number */
  REG_GENL_A_EVENT,                     /* This attribute defines the regulator event */
  __REG_GENL_A_COUNT,
};
#define REG_GENL_A_MAX  (__REG_GENL_A_COUNT - 1)


/* This defines the single power regulators
 * TODO: this is platform dependent: not so good, should be replaced with a
 *       better solution.
 */
#define REG_GENL_ID_IGNITION_IRQ    0   /* Ignition IRQ, aka "Klemme 15" */
#define REG_GENL_ID_IGNITION_OVR    1   /* Ignition override */
/* Other regulators not required yet */

/* This header contains the event specifications for the attribute "REG_GENL_A_EVENT" */
#define REG_GENL_EVENT_POWER_ON     0
#define REG_GENL_EVENT_POWER_OFF    1


#endif /*REGNETLINK_H_*/
