/*
 * v4l2_we.h
 * @brief Wachendorff specific V4L2 definitions
 * @copyright (c) 2013 Wachendorff Elektronik GmbH & Co. KG
 * @author Thomas Pinske <tpe@wachendorff.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef V4L2_WE_H_
#define V4L2_WE_H_

#include <linux/videodev2.h>

/* custom control IDs */
#define V4L2_CID_VID_NUM_IF			(V4L2_CID_PRIVATE_BASE + 4)		/* returns number of interfaces */
#define V4L2_CID_VID_ACT_IF			(V4L2_CID_PRIVATE_BASE + 5)		/* reads/sets actual interface as input source */
#define V4L2_CID_VID_MIRROR			(V4L2_CID_PRIVATE_BASE + 7)		/* video mirror (rw) */
#define V4L2_CID_VID_VIDEO_DETECT	(V4L2_CID_PRIVATE_BASE + 8)		/* check if video is detected in the chip (r) */

#endif /* V4L2_WE_H_ */
