/*----------------------------------------------------------------------------*/
/**
 * @file we_adi.h
 * @author Thomas Pinske <tpe@wachendorff.de>
 * @copyright ( c ) Wachendorff Elektronik GmbH & Co. KG 2008 - 2010
 * @brief Analog/digital input driver
 * @version V1.4
 * @date 2010-05-03
 * 
 * This file contains the definitions for the user interface and the platform
 * configuration of the analog/digital input devices.
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/

#ifndef _WE_ADI_H
#define _WE_ADI_H


#include <asm/types.h>

/*----------------------------------------------------------------------------*/
/* @struct we_adi_value
 * @brief device read data structure
 * This function is returned by a read operation to a device file. It contains
 * the current value of an input.
 */
struct we_adi_value
{
  __u16 value;                          /*!< input value */
};

/* operation mode */
#define WE_ADI_MODE_DIGITAL 0           /*!< act as digital input */
#define WE_ADI_MODE_ANALOG  1           /*!< act as analog input */
struct we_adi_mode
{
  __u8 mode;                            /*!< operation mode (0=digital/1=analog) */
};
#define WE_ADI_MODE_READ                _IOR(0xE0, 0x01, struct we_adi_mode)
#define WE_ADI_MODE_WRITE               _IOW(0xE0, 0x02, struct we_adi_mode)

/* event signalling */
#define WE_ADI_EVENT_CHANGE   0x01      /*!< event "change" bit mask */
#define WE_ADI_EVENT_LOWPASS  0x02      /*!< event "low pass" bit mask */
#define WE_ADI_EVENT_HIGHPASS 0x04      /*!< event "high pass" bit mask */
struct we_adi_event
{
  __u8  event;                          /* event mask */
  __u16 value;                          /* input value */
};
#define WE_ADI_EVENT_WAIT               _IOR(0xE0, 0x03, struct we_adi_event)

/* event configuration */
struct we_adi_event_config
{
  __u16 change_hysteresis;              /* hysteresis for state change event */
  __u16 limit_low;                      /* low pass value */
  __u16 limit_high;                     /* high pass value */
};
#define WE_ADI_EVENT_CONFIG_READ        _IOR(0xE0, 0x04, struct we_adi_event_config)
#define WE_ADI_EVENT_CONFIG_WRITE       _IOW(0xE0, 0x05, struct we_adi_event_config)



#endif /*_WE_ADI_H*/
