/*----------------------------------------------------------------------------*/
/**
 * @file we_beeper.h
 * @author Thomas Pinske <tpe@wachendorff.de>
 * @copyright ( c ) Wachendorff Elektronik GmbH & Co. KG 2008, 2009
 * @brief Beeper driver
 * @version V1.0
 * @date 2009-07-09
 * 
 * This file contains definitions for the user interface and platform
 * configuration of the beeper devices, which are driven over a PWM
 * of the CPU.
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/

#ifndef _WE_BEEPER_H
#define _WE_BEEPER_H


#include <asm/types.h>

#define WE_BEEPER_SYS_GENL_NAME    "WE_BEEPER"
#define WE_BEEPER_SYS_GENL_VERSION 1

/**
 * @enum <unnamed>
 * @brief This enum lists all supported commands of event interface
 */
enum
{
	BEEP_GENL_C_UNSPEC,
	BEEP_GENL_C_EVENT,                     /* This command signals an event */
  __BEEP_GENL_C_COUNT,
};
#define BEEP_GENL_C_MAX   (__BEEP_GENL_C_COUNT - 1)


/**
 * @enum <unnamed>
 * @brief This enum lists all supported attributes of the beeper event interface
 */
enum
{
	BEEP_GENL_A_UNSPEC,
	BEEP_GENL_A_NUM, /* This attribute defines the beeper number */
	BEEP_GENL_A_EVENT, /* This attribute defines the beeper event */
	BEEP_GENL_A_VALUE, /* This attribute defines the beeper value (volume) */
	__BEEP_GENL_A_COUNT,
};
#define BEEP_GENL_A_MAX  (__BEEP_GENL_A_COUNT - 1)

/* event signalling */
#define WE_BEEPER_EVENT_CHANGE   0x01   /*!< event "change" bit mask */

/*----------------------------------------------------------------------------*/
/* @struct we_beeper_volume
 * @brief device read and write data structure
 * This function is returned by a read or is expected by a write operation to
 * a device file. It contains the volume of the beeper
 */
/*----------------------------------------------------------------------------*/
struct we_beeper_volume
{
  __u8 volume;                          /*!< beeper volume */
};


/* event signalling */
#define WE_BEEPER_EVENT_CHANGE  0x01    /*!< event "change" bit mask */





#endif

