/*----------------------------------------------------------------------------*/
/**
 * @file we_cco.h
 * @author Thomas Pinske <tpe@wachendorff.de>
 * @copyright ( c ) Wachendorff Elektronik GmbH & Co. KG 2008, 2009
 * @brief Camera control output driver
 * @version V1.0
 * @date 2009-07-09
 * 
 * This file contains the definitions for the user interface and the platform
 * configuration of the camera control output devices.
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/

#ifndef _WE_CCO_H
#define _WE_CCO_H


#include <asm/types.h>


/*============================================================================*/
/* DEVICE INTERFACE                                                           */
/*============================================================================*/

/*----------------------------------------------------------------------------*/
/* @struct we_cco_state
 * @brief device read and write data structure
 * This function is returned by a read or is expected by a write operation to
 * a device file. It contains the state of an output.
 */
#define WE_CCO_STATE_OFF 0              /*!< output state off */
#define WE_CCO_STATE_ON  1              /*!< output state on */
struct we_cco_state
{
  __u8 state;                           /*!< output state */
};


/* event signalling */
#define WE_CCO_EVENT_CHANGE 0x01      /*!< event "change" bit mask */
struct we_cco_event
{
  __u8 event;                           /* event mask */
  __u8 state;                           /* output state */
};
#define WE_CCO_EVENT_WAIT               _IOR(0xE0, 0x21, struct we_cco_event)



#endif
