/*----------------------------------------------------------------------------*/
/**
 * @file we_dio_event.h
 * @author Thomas Pinske <tpe@wachendorff.de>
 * @copyright ( c ) Wachendorff Elektronik GmbH & Co. KG 2008 - 2013
 * @brief Generic netlink event interface definition for digital I/O ports
 *
 * This file contains the definitions for the WE generic netlink interface, which
 * can be used by digital input and output drivers to implement the WE event
 * interface in digital input and output drivers. Based on WE digital output
 * implementation.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/


#ifndef WE_DIO_EVENT_H_
#define WE_DIO_EVENT_H_

#define WE_DIO_SYS_GENL_NAME_DIO	"WE_DIO"		/* use this for combined digital input/output drivers */
#define WE_DIO_SYS_GENL_NAME_DI		"WE_DI"			/* use this for digital input drivers */
#define WE_DIO_SYS_GENL_NAME_DO		"WE_DO"			/* use this for digital output drivers */
#define WE_DIO_SYS_GENL_VERSION		1

/**
 * @enum <unnamed>
 * @brief This enum lists all supported commands of event interface
 */
enum
{
	DIO_GENL_C_UNSPEC,
	DIO_GENL_C_EVENT,                     /* This command signals an event */
  __DIO_GENL_C_COUNT,
};
#define DIO_GENL_C_MAX	(__DIO_GENL_C_COUNT - 1)

/**
 * @enum <unnamed>
 * @brief This enum lists all supported attributes of the DIO-event interface
 */
enum
{
	DIO_GENL_A_UNSPEC,
	DIO_GENL_A_NUM,			/* This attribute defines the DIO number */
	DIO_GENL_A_EVENT,		/* This attribute defines the DIO event */
	DIO_GENL_A_VALUE,		/* This attribute defines the input/output value (DIO) */
  __DIO_GENL_A_COUNT,
};
#define DIO_GENL_A_MAX	(__DIO_GENL_A_COUNT - 1)

/* event signaling */
#define WE_DIO_EVENT_CHANGE		0x01		/*!< event "change" bit mask */

#endif /* WE_DIO_EVENT_H_ */
