/*----------------------------------------------------------------------------*/
/**
 * @file we_do.h
 * @author Thomas Pinske <tpe@wachendorff.de>
 * @copyright ( c ) Wachendorff Elektronik GmbH & Co. KG 2008, 2009
 * @brief Digital output driver
 * @version V1.0
 * @date 2009-07-09
 * 
 * This file contains the definitions for the user interface and the platform
 * configuration of the digital output devices.
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/

#ifndef _WE_DO_H
#define _WE_DO_H


#include <asm/types.h>


/*============================================================================*/
/* DEVICE INTERFACE                                                           */
/*============================================================================*/

/*----------------------------------------------------------------------------*/
/* @struct we_do_state
 * @brief device read and write data structure
 * This function is returned by a read or is expected by a write operation to
 * a device file. It contains the state of an output.
 */
#define WE_DO_STATE_OFF 0               /*!< output state off */
#define WE_DO_STATE_ON  1               /*!< output state on */
struct we_do_state
{
  __u8 state;                           /*!< output value */
};


/* event signalling */
#define WE_DO_EVENT_CHANGE   0x01       /*!< event "change" bit mask */
struct we_do_event
{
  __u8 event;                           /* event mask */
  __u8 state;                           /* output state */
};
#define WE_DO_EVENT_WAIT                _IOR(0xE0, 0x11, struct we_do_event)



// NEW EVENT
#define WE_DIO_SYS_GENL_NAME    "WE_DIO"
#define WE_DIO_SYS_GENL_VERSION 1

/**
 * @enum <unnamed>
 * @brief This enum lists all supported commands of event interface
 */
enum
{
	DIO_GENL_C_UNSPEC,
	DIO_GENL_C_EVENT,                     /* This command signals an event */
  __DIO_GENL_C_COUNT,
};
#define DIO_GENL_C_MAX   (__DIO_GENL_C_COUNT - 1)


/**
 * @enum <unnamed>
 * @brief This enum lists all supported attributes of the DIO-event interface
 */
enum
{
	DIO_GENL_A_UNSPEC,
	DIO_GENL_A_NUM, /* This attribute defines the DIO number */
	DIO_GENL_A_EVENT, /* This attribute defines the DIO event */
	DIO_GENL_A_VALUE, /* This attribute defines the input/output value (DIO) */
	__DIO_GENL_A_COUNT,
};
#define DIO_GENL_A_MAX  (__DIO_GENL_A_COUNT - 1)

/* event signalling */
#define WE_DIO_EVENT_CHANGE   0x01   /*!< event "change" bit mask */


#endif
