/*----------------------------------------------------------------------------*/
/**
 * @file we_genl_misc_intf.h
 * @author Sathees.copyright (c) Wachendorff Elektronik GmbH & Co. KG 2009, 2010
 * @brief generic netlink common header file
 * @version V1.0
 * @date 2010-02-19
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 *
 *  @version V1.1
 *	@author sathees
 *	@date	2010-07-08
 *	@brief	Status packet WE_POWER_WLAN_RESET has been added
 */
/*----------------------------------------------------------------------------*/

#ifndef WE_GENL_MISC_INTF_H_
#define WE_GENL_MISC_INTF_H_

#ifndef SOL_NETLINK
#define SOL_NETLINK 270
#endif


#define WE_GENL_MISC_NAME				"we_genl_misc" 		/*!< generic netlink family name */
#define WE_GENL_MISC_MCAST_GRP_NAME		"we_genl_misc_mc"	/*!< multicast group name */
#define VERSION_NUMBER 	1

#define NLMSG_DATA1(nlh)  ((char*)(((char*)nlh) + NLMSG_LENGTH(0)))

#define GENLMSG_DATA(glh) ((char*)(NLMSG_DATA1(glh) + GENL_HDRLEN))
#define GENLMSG_PAYLOAD(glh) (NLMSG_PAYLOAD(glh, 0) - GENL_HDRLEN)
#define NLA_DATA(na) ((char*)((char*)(na) + NLA_HDRLEN))


/*! attributes (variables): the index in this enum is used as a reference for the type,
 * userspace application has to indicate the corresponding type the policy is used for
 * security considerations
 */
enum {

	WE_GENL_MISC_ATTR_UNSPEC,
	WE_GENL_MISC_ATTR_MCAST_GRP_NAME,
	WE_GENL_MISC_ATTR_MCAST_GRP_ID,
	WE_GENL_MISC_ATTR_EVENT_MSG,
    __WE_GENL_MISC_ATTR_MAX,
};
#define WE_GENL_MISC_ATTR_MAX (__WE_GENL_MISC_ATTR_MAX - 1)

/*! commands: enumeration of all commands (functions),
 * used by user space application to identify command to be executed
 */
enum {
	WE_GENL_MISC_CMD_UNSPEC,
	WE_GENL_MISC_CMD_GETMCAST_GRP,
	__WE_GENL_MISC_CMD_MAX,
};
#define WE_GENL_MISC_CMD_MAX (__WE_GENL_MISC_CMD_MAX - 1)


/*============================================================================*/
/* STATUS PACKETS (FOR NERLINK INTERFACE)                                     */
/*============================================================================*/

/*----------------------------------------------------------------------------*/
/*! Device file  - we_backlight.0/brightness
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_BACKLIGHT_BRIGHTNESS (packet type)
 * @n Byte 1 - 0 or 100 (new brightness value, set by the user)
 */
#define WE_BACKLIGHT_BRIGHTNESS					(0x01)

/*! Device file - we_led.0/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_LED_STATE (packet type)
 * @n Byte 1 - 0 or 1 (new led state, set by the user)
 */
#define WE_LED_STATE							(0x02)

/*! Device file - we_beeper.0/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_BEEPER_STATUS (packet type)
 * @n Byte 1 - 0 or 1 (beeper status, set by the user)
 */
#define WE_BEEPER_STATUS						(0x03)
/*----------------------------------------------------------------------------*/
/*! Device file - we_power.0/ignition_status
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_POWER_KL15_STATE (packet type)
 * @n Byte 1 - 0 or 1  ( KL15 ignition status, from hardware)
 * @n Byte 2 - bit 0-7 (system shutdown timeout lower order,timeout in seconds. range is -1
   to 300. -1 for no shutdown.)
 * @n Byte 3 - bit 8-15(system shutdown timeout higher order)
  */
#define WE_POWER_KL15_STATE						(0x10)

/*! Device file - we_power.0/shutdown_timeout. System timeout range is -1
 *  to 300. -1 for no shutdown.
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_POWER_SHUTDOWN_TIMEOUT (packet type)
 * @n Byte 1 - bit 0-7 (system shutdown timeout lower order, set by the user)
 * @n Byte 2 - bit 8-15(system shutdown timeout higher order, set by the user)
 */
#define WE_POWER_SHUTDOWN_TIMEOUT				(0x11)

/*! Device file - we_power.0/wlan_reset.
 * @n Packet length - 1 byte
 * @n Byte 0 - WE_POWER_WLAN_RESET (packet type)
 */
#define WE_POWER_WLAN_RESET						(0x12)

/*----------------------------------------------------------------------------*/
/*! Device file - we_di.0/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DI_0_STATUS (packet type)
 * @n Byte 1 - 0 or 1 ( input status, from hardware)
 */
#define WE_DI_0_STATUS							(0x20)

/*! Device file - we_di.1/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DI_1_STATUS (packet type)
 * @n Byte 1 - 0 or 1 ( input status, from hardware)
 */
#define WE_DI_1_STATUS							(0x21)

/*! Device file - we_di.2/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DI_2_STATUS (packet type)
 * @n Byte 1 - 0 or 1 ( input status, from hardware)
 */
#define WE_DI_2_STATUS							(0x22)

/*! Device file - we_di.3/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DI_3_STATUS (packet type)
 * @n Byte 1 - 0 or 1 (input status)
 */
#define WE_DI_3_STATUS							(0x23)

/*! Device file - we_di.3/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_SD_DOOR_STATUS (packet type)
 * @n Byte 1 - 0 or 1 (input status)
 */
#define WE_SD_DOOR_STATUS						(0x24)
/*--------------------------------------------------------------------------- */

/*! Device file - we_do.0/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DO_0_STATUS (packet type)
 * @n Byte 1 - 0 or 1 (new output status, set by the user)
 */
#define WE_DO_0_STATUS							(0x30)

/*! Device file - we_do.1/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DO_1_STATUS (packet type)
 * @n Byte 1 - 0 or 1 (new output status, set by the user)
 */
#define WE_DO_1_STATUS							(0x31)

/*! Device file - we_do.2/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DO_2_STATUS (packet type)
 * @n Byte 1 - 0 or 1 (new output status, set by the user)
 */
#define WE_DO_2_STATUS							(0x32)

/*! Device file - we_do.3/status
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_DO_3_STATUS (packet type)
 * @n Byte 1 - 0 or 1 (new output status, set by the user)
 */
#define WE_DO_3_STATUS							(0x33)
/*----------------------------------------------------------------------------*/

/*! Device file - we_sensor.0/hysteresis (KL30_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_0_HYSTERESIS (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 1 t0 10)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_SENSOR_0_HYSTERESIS					(0x40)

/*! Device file - we_sensor.1/hysteresis (TEMP_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_1_HYSTERESIS (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 1 t0 300)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_SENSOR_1_HYSTERESIS					(0x41)

/*! Device file - we_sensor.2/hysteresis (LIGHT_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_2_HYSTERESIS (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 1 t0 300)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_SENSOR_2_HYSTERESIS					(0x42)

/*! Device file - we_sensor.0/low_limit (KL30_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_0_HYS_LOW_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis low_limit lower order, set by the user, total range 1 t0 50000)
 * @n Byte 2 - bit 8-15 (hysteresis low_limit higher order, set by the user)
 */
#define WE_SENSOR_0_HYS_LOW_LIMIT				(0x43)

/*! Device file - we_sensor.1/low_limit (TEMP_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_1_HYS_LOW_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis value low_limit lower order, set by the user, total range -55 t0 125)
 * @n Byte 2 - bit 8-15 (hysteresis value low_limit higher order, set by the user)
 */
#define WE_SENSOR_1_HYS_LOW_LIMIT				(0x44)

/*! Device file - we_sensor.2/low_limit (LIGHT_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_2_HYS_LOW_LIMIT (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis low_limit lower order, set by the user, total range 0 t0 255)
 * @n Byte 2 - bit 8-15 (hysteresis low_limit higher order, set by the user)
 */
#define WE_SENSOR_2_HYS_LOW_LIMIT				(0x45)

/*! Device file - we_sensor.0/high_limit (KL30_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_0_HYS_HIGH_LIMIT (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis low_limit, set by the user, total range 1 t0 50000)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_SENSOR_0_HYS_HIGH_LIMIT				(0x46)

/*! Device file - we_sensor.1/high_limit (TEMP_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_1_HYS_HIGH_LIMIT (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range -55 t0 125)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_SENSOR_1_HYS_HIGH_LIMIT				(0x47)

/*! Device file - we_sensor.2/high_limit (LIGHT_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_2_HYS_HIGH_LIMIT (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 0 t0 255)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_SENSOR_2_HYS_HIGH_LIMIT				(0x48)

/*! Device file - we_sensor.0/sensor_value (KL30_SENSOR)
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_SENSOR_0_SENSOR_VALUE (packet type)
 * @n Byte 1 - bit 0-7 (sensor value lower order, from the hardware, total range 0 t0 50000)
 * @n Byte 2 - bit 8-15 (sensor value higher order, set by the user)
 * @n Byte 3 - -1 t0 2 ( 0 - within hysteresis limit, 1 - lesser than the low_limit,
 *                      2 -greater than the high_limit, -1 - error in dev id index)
 */
#define WE_SENSOR_0_SENSOR_VALUE                (0x49)

/*! Device file - we_sensor.1/sensor_value (TEMP_SENSOR)
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_SENSOR_1_SENSOR_VALUE (packet type)
 * @n Byte 1 - bit 0-7 (sensor value lower order, from the hardware, total range -55 t0 125)
 * @n Byte 2 - bit 8-15 (sensor value higher order, set by the user)
 * @n Byte 3 - -1 t0 2 ( 0 - within hysteresis limit, 1 - lesser than the low_limit,
 *                      2 -greater than the high_limit, -1 - error in dev id index)
 */
#define WE_SENSOR_1_SENSOR_VALUE                (0x4A)

/*! Device file - we_sensor.2/sensor_value (LIGHT_SENSOR)
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_SENSOR_2_SENSOR_VALUE (packet type)
 * @n Byte 1 - bit 0-7 (sensor value lower order, from the hardware, total range 0 t0 255)
 * @n Byte 2 - bit 8-15 (sensor value higher order, set by the user)
 * @n Byte 3 - -1 t0 2 ( 0 - within hysteresis limit, 1 - lesser than the low_limit,
 *                      2 -greater than the high_limit, -1 - error in dev id index)
 */
#define WE_SENSOR_2_SENSOR_VALUE                (0x4B)
/*----------------------------------------------------------------------------*/

/*! Device file - we_ai.0/hysteresis
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_AI_0_HYSTERESIS (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_AI_0_HYSTERESIS                      (0x50)

/*! Device file - we_ai.1/hysteresis
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_AI_1_HYSTERESIS (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_AI_1_HYSTERESIS                      (0x51)

/*! Device file - we_ai.2/hysteresis
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_AI_2_HYSTERESIS (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_AI_2_HYSTERESIS                      (0x52)

/*! Device file - we_ai.3/hysteresis
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_AI_3_HYSTERESIS (packet type)
 * @n Byte 1 - bit 0-7 (hysteresis value lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis value higher order, set by the user)
 */
#define WE_AI_3_HYSTERESIS                      (0x53)

/*! Device file - we_ai.0/low_limit (KL30_SENSOR)
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_0_HYS_LOW_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis low_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis low_limit higher order, set by the user)
 */
#define WE_AI_0_HYS_LOW_LIMIT					(0x54)

/*! Device file - we_ai.0/low_limit
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_1_HYS_LOW_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis low_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis low_limit higher order, set by the user)
 */
#define WE_AI_1_HYS_LOW_LIMIT					(0x55)

/*! Device file - we_ai.0/low_limit
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_2_HYS_LOW_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis low_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis low_limit higher order, set by the user)
 */
#define WE_AI_2_HYS_LOW_LIMIT					(0x56)

/*! Device file - we_ai.0/low_limit
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_3_HYS_LOW_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis low_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis low_limit higher order, set by the user)
 */
#define WE_AI_3_HYS_LOW_LIMIT					(0x57)

/*! Device file - we_ai.0/high_limit
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_0_HYS_HIGH_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis high_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis high_limit higher order, set by the user)
 */
#define WE_AI_0_HYS_HIGH_LIMIT					(0x58)

/*! Device file - we_ai.0/high_limit
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_1_HYS_HIGH_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis high_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis high_limit higher order, set by the user)
 */
#define WE_AI_1_HYS_HIGH_LIMIT					(0x59)

/*! Device file - we_ai.0/high_limit
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_2_HYS_HIGH_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis high_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis high_limit higher order, set by the user)
 */
#define WE_AI_2_HYS_HIGH_LIMIT					(0x5A)

/*! Device file - we_ai.0/high_limit
 * @n Packet length - 3 bytes.
 * @n Byte 0 - WE_SENSOR_3_HYS_HIGH_LIMIT (packet type)
 * @n Byte 1 - bit 0-7  (hysteresis high_limit lower order, set by the user, total range 1 t0 14100)
 * @n Byte 2 - bit 8-15 (hysteresis high_limit higher order, set by the user)
 */
#define WE_AI_3_HYS_HIGH_LIMIT					(0x5B)

/*! Device file - we_ai.0/adc_value
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_AI_0_ADC_VALUE (packet type)
 * @n Byte 1 - bit 0-7 (adc value lower order, from the hardware, total range 0 t0 14100)
 * @n Byte 2 - bit 8-15 (adc value higher order, set by the user)
 * @n Byte 3 - -1 t0 2 ( 0 - within hysteresis limit, 1 - lesser than the low_limit,
 *                      2 -greater than the high_limit, -1 - error in dev id index)
 */
#define WE_AI_0_ADC_VALUE						(0x5C)

/*! Device file - we_ai.1/adc_value
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_AI_1_ADC_VALUE (packet type)
 * @n Byte 1 - bit 0-7 (adc value lower order, from the hardware, total range 0 t0 14100)
 * @n Byte 2 - bit 8-15 (adc value higher order, set by the user)
 * @n Byte 3 - -1 t0 2 ( 0 - within hysteresis limit, 1 - lesser than the low_limit,
 *                      2 -greater than the high_limit, -1 - error in dev id index)
 */
#define WE_AI_1_ADC_VALUE						(0x5D)

/*! Device file - we_ai.2/adc_value
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_AI_2_ADC_VALUE (packet type)
 * @n Byte 1 - bit 0-7 (adc value lower order, from the hardware, total range 0 t0 14100)
 * @n Byte 2 - bit 8-15 (adc value higher order, set by the user)
 * @n Byte 3 - -1 t0 2 ( 0 - within hysteresis limit, 1 - lesser than the low_limit,
 *                      2 -greater than the high_limit,-1 - error in dev id index)
 */
#define WE_AI_2_ADC_VALUE						(0x5E)

/*! Device file - we_ai.3/adc_value
 * @n Packet length - 4 bytes.
 * @n Byte 0 - WE_AI_3_ADC_VALUE (packet type)
 * @n Byte 1 - bit 0-7 (adc value lower order, from the hardware, total range 0 t0 14100)
 * @n Byte 2 - bit 8-15 (adc value higher order, set by the user)
 * @n Byte 3 - -1 t0 2 ( 0 - within hysteresis limit, 1 - lesser than the low_limit,
 *                      2 -greater than the high_limit,-1 - error in dev id index)
 */
#define WE_AI_3_ADC_VALUE						(0x5F)
/*----------------------------------------------------------------------------*/


/* ############ POWER MANAGEMENT ################################################ */


/*! Device file - we_display.o/pm/state
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_ARM1_DISPLAY_POWER_STATE (packet type)
 * @n Byte 1 - 0 or 1 (suspend or resume)
 */
#define WE_ARM1_DISPLAY_POWER_STATE					(0x60)

/*! Device file - we_beeper.o/pm/state
 * @n Packet length - 2 bytes.
 * @n Byte 0 - WE_ARM1_BEEPER_POWER_STATE (packet type)
 * @n Byte 1 - 0 or 1 (suspend or resume)
 */
#define WE_ARM1_BEEPER_POWER_STATE					(0x61)




#endif /* WE_GENL_MISC_INTF_H_ */
