/*----------------------------------------------------------------------------*/
/**
 * @file we_sensor.h
 * @author Thomas Pinske <tpe@wachendorff.de>
 * @author Thorsten Schmelzer <tsr@wachendorff.de>
 * @copyright ( c ) Wachendorff Elektronik GmbH & Co. KG 2008 - 2012
 * @brief Sensor device driver
 * @version V2.0
 * @date 2012-10-15
 * 
 * This file contains the definitions for the user interface and the platform
 * configuration of the sensor devices.
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, version 2.
 */
/*----------------------------------------------------------------------------*/

#ifndef _WE_SENSOR_H
#define _WE_SENSOR_H


#include <asm/types.h>

#define WE_SENSOR_GENL_NAME    "WE_SENSOR"
#define WE_SENSOR_GENL_VERSION 1

/**
 * @enum <unnamed>
 * @brief This enum lists all supported commands of event interface
 */
enum
{
  SENS_GENL_C_UNSPEC,
  SENS_GENL_C_EVENT,                     /* This command signals an event */
  __SENS_GENL_C_COUNT,
};
#define SENS_GENL_C_MAX   (__SENS_GENL_C_COUNT - 1)

/**
 * @enum <unnamed>
 * @brief This enum lists all supported attributes of the sensor event interface
 */
enum
{
	SENS_GENL_A_UNSPEC,
	SENS_GENL_A_SENSOR, /* This attribute defines the sensor number */
	SENS_GENL_A_EVENT, /* This attribute defines the sensor event */
	SENS_GENL_A_VALUE, /* This attribute defines the sensor value */
	__SENS_GENL_A_COUNT,
};
#define SENS_GENL_A_MAX  (__SENS_GENL_A_COUNT - 1)

/* event signalling */
#define WE_SENSOR_EVENT_CHANGE   0x01   /*!< event "change" bit mask */
#define WE_SENSOR_EVENT_LOWPASS  0x02   /*!< event "low pass" bit mask */
#define WE_SENSOR_EVENT_HIGHPASS 0x04   /*!< event "high pass" bit mask */


#endif /*_WE_SENSOR_H*/
