/*************************************************************************
 * *
 * * FILENAME: alogics_app_int.h
 * *
 * * DESCRIPTION:
 * * The IOCTL declarations here have to be in a header file, because
 * * they need to be known both to the kernel module
 * * (in app_interface.c) and the process calling ioctl (app_ioctl.c)
 * *
 * *
 * * PUBLIC FUNCTIONS:
 * * NONE
 * * 
 * * $Revision: 1.1.1.1 $
 * * $Author: tsr $
 * * $Modtime: $
 * * $Archive: $
 * *
 ***************************************************************************/
#ifndef APPINT_H_INCLUDED
#define APPINT_H_INCLUDED

#include <linux/ioctl.h>
#define MAJOR_NUM 202
#define ZERO 0
#define SUCCESS 0
#define DEVICE_NAME "appdev"    /* Dev name as it appears in /proc/devices   */
#define BUF_LEN 10

/*
 * _IOR means that we're creating an ioctl command 
 * number for passing information from a user process
 * to the kernel module. 
 *
 * The first arguments, MAJOR_NUM, is the major device 
 * number we're using.
 *
 * The second argument is the number of the command 
 * (there could be several with different meanings).
 *
 * The third argument is the type we want to get from 
 * the process to the kernel.
 */

#define IOCTL_SET_AM7416_REGISTER			_IOR(MAJOR_NUM,0,unsigned char)
#define IOCTL_AM7416_CHIP_RESET                         _IOR(MAJOR_NUM,1,unsigned char)
#define IOCTL_NVP1004_CHIP_RESET                        _IOR(MAJOR_NUM,2,unsigned char)
#define IOCTL_SET_NVP1004_REGISTER			_IOR(MAJOR_NUM,3,unsigned char)
#define IOCTL_GET_NVP1004_REGISTER			_IOR(MAJOR_NUM,4,unsigned char)
#define IOCTL_GET_AM7416_REGISTER			_IOR(MAJOR_NUM,5,unsigned char)
#define IOCTL_CAPTURE_START                             _IOR(MAJOR_NUM,6,unsigned char) 
#define IOCTL_CAPTURE_STOP	                        _IOR(MAJOR_NUM,7,unsigned char)
#define IOCTL_1_FULL_WINDOW                             _IOR(MAJOR_NUM,8,unsigned char)
#define IOCTL_2_WINDOWS					_IOR(MAJOR_NUM,9,unsigned char)
#define IOCTL_4_WINDOWS					_IOR(MAJOR_NUM,10,unsigned char)
#define IOCTL_5_WINDOWS					_IOR(MAJOR_NUM,11,unsigned char)
#define IOCTL_6_WINDOWS					_IOR(MAJOR_NUM,12,unsigned char)
#define IOCTL_7_WINDOWS					_IOR(MAJOR_NUM,13,unsigned char)
#define IOCTL_8_WINDOWS					_IOR(MAJOR_NUM,14,unsigned char)
#define IOCTL_SET_HUE					_IOR(MAJOR_NUM,15,unsigned char)
#define IOCTL_SET_BRIGHTNESS				_IOR(MAJOR_NUM,16,unsigned char)
#define IOCTL_SET_CONTRAST				_IOR(MAJOR_NUM,17,unsigned char)
#define IOCTL_SET_SATURATION				_IOR(MAJOR_NUM,18,unsigned char)
#define IOCTL_CAMERA_IN_CHANNEL				_IOR(MAJOR_NUM,19,unsigned char)
#define IOCTL_SUBWINDOW_MIRROR 				_IOR(MAJOR_NUM,20,unsigned char)
#define DEVICE_FILE_NAME "appdev"
#endif
