/**
 * @file wehmd_api.h
 * @brief API definitions for the Wachendorff Health Management Daemon (wehmd)
 * 
 * @autor Thorsten Schmelzer <tsr@wachendorff.de>
 * @copyright ( C ) 2011 Wachendorff Elektronik GmbH & Co. KG, Geisenheim
 * 
 * This file contains the definitions for the WE Health Management Daemon
 * application programming interface. Include this to your own sources, if
 * you want to use this API.
 */

#ifndef WEHMD_API_H_
#define WEHMD_API_H_

/*
 * path of the API socket (UNIX domain socket)
 */
#define WEHMD_API_SOCKET    "/var/run/wehmd_api"


#define WEHMD_API_VERSION 4


/*
 * maximum length of device name. Use this for string copy function etc.
 */
#define WEHMD_MAX_DEV_NAME  15

/**
 * @enum wehmd_cmd_t
 * @brief List of all API commands
 * Append new commands at the end to ensure backward compatibility!
 */
typedef enum
{
	WEHMD_CMD_GET_OTC = 0,
	WEHMD_CMD_OTC,
	WEHMD_CMD_GET_EE_PRODUCT_TYPE,
	WEHMD_CMD_EE_PRODUCT_TYPE,
	WEHMD_CMD_GET_EE_PRODUCT_VARIANT,
	WEHMD_CMD_EE_PRODUCT_VARIANT,
	WEHMD_CMD_GET_EE_BOARD_REVISION,
	WEHMD_CMD_EE_BOARD_REVISION,
	WEHMD_CMD_GET_EE_BOARD_NAME,
	WEHMD_CMD_EE_BOARD_NAME,
	WEHMD_CMD_GET_EE_PART_NUMBER,
	WEHMD_CMD_EE_PART_NUMBER,
	WEHMD_CMD_GET_EE_SERIAL_NUMBER,
	WEHMD_CMD_EE_SERIAL_NUMBER,
	WEHMD_CMD_GET_EE_BOOT_MODE,
	WEHMD_CMD_EE_BOOT_MODE,
	WEHMD_CMD_GET_EE_UNIQUE_RELEASE_ID,
	WEHMD_CMD_EE_UNIQUE_RELEASE_ID,
	WEHMD_CMD_GET_EE_DELETE_DIAG,
	WEHMD_CMD_EE_DELETE_DIAG,
	WEHMD_CMD_GET_EE_CONSOLE_MODE,
	WEHMD_CMD_EE_CONSOLE_MODE,
	WEHMD_CMD_GET_API_VERSION,
	WEHMD_CMD_API_VERSION,
	WEHMD_CMD_ERROR,
	WEHMD_CMD_SET_EE_CONSOLE_MODE,
	WEHMD_CMD_GET_EE_DISPLAY_BRIGHTNESS,
	WEHMD_CMD_SET_EE_DISPLAY_BRIGHTNESS,
	WEHMD_CMD_EE_DISPLAY_BRIGHTNESS,
	WEHMD_CMD_GET_EE_KEYPAD_BRIGHTNESS,
	WEHMD_CMD_SET_EE_KEYPAD_BRIGHTNESS,
	WEHMD_CMD_EE_KEYPAD_BRIGHTNESS,
    WEHMD_CMD_SET_EE_BOOT_MODE,
    WEHMD_CMD_SET_EE_RAM_TEST,
    WEHMD_CMD_GET_EE_RAM_TEST,
    WEHMD_CMD_EE_RAM_TEST,
	WEHMD_CMD_GET_EE_KEYPAD_COLOR,
	WEHMD_CMD_SET_EE_KEYPAD_COLOR,
	WEHMD_CMD_EE_KEYPAD_COLOR,
} wehmd_cmd_t;


/**
 * @enum wehmd_err_type_t
 * @brief List of all API errors
 * Append new errors at the end to ensure backward compatibility!
 */
typedef enum
{
	WEHMD_ERR_UNKNOWN_COMMAND=0,
	WEHMD_ERR_EEPROM_NOT_AVAILABLE,
	WEHMD_ERR_COULD_NOT_READ,
	WEHMD_ERR_NOT_A_CLIENT_COMMAND,
	WEHMD_ERR_COULD_NOT_WRITE,
	WEHMD_ERR_ALREADY_SET,
	WEHMD_ERR_COMMAND_NOT_SUPPORTED,
} wehmd_err_type_t;


/**
 * @struct wehmd_error_t
 * @brief error messages for socket communication
 */
typedef struct
{
	/* command which caused the error */
	wehmd_cmd_t command;
	/* type of error */
	wehmd_err_type_t errorType;
} wehmd_error_t;


/**
 * @union wehmd_msg_data_t
 * @brief Payload data of one API message
 * 
 * This is the data portion of one API message. Each message exists of a
 * command the corresponding payload data, which can be different from
 * command to command. Please take a look to the documentation for further
 * details of the API message format.
 */
typedef union
{
	unsigned int otc;
	unsigned char productType;
	unsigned char productVariant;
	unsigned char boardRevision;
	char boardName[31];
	char partNumber[21];
	char serialNumber[21];
	unsigned char bootMode;
	unsigned int uniqueReleaseID;
	unsigned char deleteDiag;
	unsigned char consoleMode;
	unsigned int apiVersion;
	unsigned char displayBrightness;
	unsigned char keypadBrightness;
	unsigned int keypadColor;
	unsigned char ramTest;
	wehmd_error_t error;
} wehmd_msg_data_t;


/**
 * @struct wehmd_msg_t
 * @brief wehmd API message
 */
typedef struct
{
	/* API command */
	wehmd_cmd_t command;

	/* payload data */
	wehmd_msg_data_t data;
} wehmd_msg_t;


#endif /*WEHMD_API_H_*/
